<?php

/**
 * Created by PhpStorm.
 * User: Danut
 * Date: 12/9/2015
 * Time: 12:21 PM
 */
class TCB_Product extends TVE_Dash_Product_Abstract {
	protected $tag = 'tcb';

	protected $title = 'Thrive Architect';

	protected $productIds = array();

	protected $type = 'plugin';

	protected $needs_architect = true;

	/**
	 * Whether or not the current user can open the architect editor based on the current request
	 * e.g.
	 * editing a TL form and having TL access
	 * etc
	 *
	 * @param int $post_id if want to check if the current user can edit the current post
	 *
	 * @return  bool
	 */
	public static function has_external_access( $post_id = null ) {
		$has_edit_access = true;
		if ( $post_id ) {
			$has_edit_access = current_user_can( 'edit_post', $post_id );
		}

		/**
		 * If Architect and plugin or just the plugin can't be used the post isn't available to edit
		 */
		return $has_edit_access && apply_filters( 'tcb_user_has_plugin_edit_cap', static::has_access() );
	}

	/**
	 * Whether or not the current user can edit current post and has TAr access
	 *
	 * @param int $post_id current post id
	 *
	 * @return bool has acccess or not
	 */
	public static function has_post_access( $post_id = 0 ) {
		return current_user_can( 'edit_post', $post_id ) && static::has_access();
	}

	public function __construct( $data = array() ) {
		parent::__construct( $data );

		$this->logoUrl      = tve_editor_css() . '/images/thrive-architect-logo.png';
		$this->logoUrlWhite = tve_editor_css() . '/images/thrive-architect-logo-white.png';

		$this->description = __( 'Create beautiful content & conversion optimized landing pages.', 'thrive-cb' );

		$this->button = array(
			'label'   => __( 'View Video Tutorial', 'thrive-cb' ),
			'url'     => '//fast.wistia.net/embed/iframe/4m07jw6fmj?popover=true',
			'active'  => true,
			'target'  => '_bank',
			'classes' => 'wistia-popover[height=450,playerColor=2bb914,width=800]',
		);

		$this->moreLinks = array(
			'tutorials' => array(
				'class'      => 'tve-leads-tutorials',
				'icon_class' => 'tvd-icon-graduation-cap',
				'href'       => 'https://thrivethemes.com/thrive-architect-tutorials/',
				'target'     => '_blank',
				'text'       => __( 'Tutorials', 'thrive-cb' ),
			),
			'support'   => array(
				'class'      => 'tve-leads-tutorials',
				'icon_class' => 'tvd-icon-life-bouy',
				'href'       => 'https://thrivethemes.com/forums/forum/plugins/thrive-architect/',
				'target'     => '_blank',
				'text'       => __( 'Support', 'thrive-cb' ),
			),
		);
	}
}
