<script type="text/javascript">
	( function ( $ ) {
		const _DELTA = 200, //for slide top animation {transform: translateY(-200px)}
			$window = $( window ),
			trigger_elements = function ( elements ) {
				elements.each( function () {
					const $elem = $( this ),
						lb_content = $elem.parents( '.tve_p_lb_content' ),
						ajax_content = $elem.parents( '.ajax-content' ),
						inViewport = TCB_Front.isInViewport( $elem, _DELTA );

					if ( lb_content.length ) {
						lb_content.on( 'tve.lightbox-open', function () {
							if ( inViewport && ! $elem.hasClass( 'tve-viewport-triggered' ) ) {
								$elem.trigger( 'tve-viewport' ).addClass( 'tve-viewport-triggered' );
							}
						} );
						return;
					}
					if ( ajax_content.length ) {
						ajax_content.on( 'content-inserted.tcb', function () {
							if ( inViewport && ! $elem.hasClass( 'tve-viewport-triggered' ) ) {
								$elem.trigger( 'tve-viewport' ).addClass( 'tve-viewport-triggered' );
							}
						} );
						return;
					}

					if ( inViewport ) {
						$elem.trigger( 'tve-viewport' ).addClass( 'tve-viewport-triggered' );
					}
				} );
			},
			trigger_exit = function ( elements ) {
				elements.each( function () {
					const $elem = $( this );

					if ( ! TCB_Front.isInViewport( $elem, _DELTA ) ) {
						$elem.trigger( 'tve-viewport-leave' ).removeClass( 'tve-viewport-triggered' );
					}
				} );
			};
		$( document ).ready( function () {
			window.tar_trigger_viewport = trigger_elements;
			window.tar_trigger_exit_viewport = trigger_exit;

			const $to_test = $( '.tve_et_tve-viewport' );
			$window.scroll( function () {
				trigger_elements( $to_test.filter( ':not(.tve-viewport-triggered)' ) );
				trigger_exit( $to_test.filter( '.tve-viewport-triggered' ) );

			} );
			setTimeout( function () {
				trigger_elements( $to_test );
			}, 200 );
		} );
	} )
	( jQuery );
</script>
