<table class="form-table postEdit">
    <tr>
        <th scope="row">
            <label><?php _e("Title", 'thrive'); ?></label>
        </th>
        <td>
            <input type="text" id="thrive_shortcode_option_title" />
        </td>
    </tr>
    <tr>
        <th scope="row">
            <label><?php _e("Number of posts", 'thrive'); ?></label>
        </th>
        <td>
            <input type="text" id="thrive_shortcode_option_no_posts" value='5' />
        </td>
    </tr>
    <tr>
        <th scope="row">
            <label><?php _e("Show", 'thrive'); ?></label>
        </th>
        <td>
            <select id="thrive_shortcode_option_filter">
                <option value='recent'><?php _e("Recent posts", 'thrive'); ?></option>
                <option value='popular'><?php _e("Popular posts", 'thrive'); ?></option>
            </select>
        </td>                        
    </tr>    
    <tr>
        <th scope="row">
            <label><?php _e("Category", 'thrive'); ?></label>
        </th>
        <td>
            <select id="thrive_shortcode_option_category">
                <?php foreach ($categories_array as $cat):?>
                <option value="<?php echo $cat['id']; ?>"><?php echo $cat['name']; ?></option>
                <?php endforeach;?>
            </select>
        </td>                        
    </tr>
    <tr>
        <td></td>
        <td>
            <input class="button button-primary" type="button" id="thrive_shortcode_btn_insert" value="<?php _e("Insert", 'thrive');?>" />
        </td>
    </tr>
</table>

<script type="text/javascript">

    jQuery(document).ready(function() {
        jQuery("#thrive_shortcode_btn_insert").click(function() {

            var sc_options = {
                'title': jQuery("#thrive_shortcode_option_title").val().replace(/"/g, '\''),
                'no_posts': jQuery("#thrive_shortcode_option_no_posts").val(),
                'filter': jQuery("#thrive_shortcode_option_filter").val(),
                'category' : jQuery("#thrive_shortcode_option_category").val()
            };
            tb_remove();
            var _sc_cat_txt = "";
            if (sc_options.category > 0) {
                _sc_cat_txt = " category='" + sc_options.category + "'";
            }

            var sc_text = '[thrive_posts_gallery' + _sc_cat_txt + ' title="' + sc_options.title + '" no_posts="' + sc_options.no_posts + '" filter="' + sc_options.filter + '"]';

            send_to_editor(sc_text);

        });
    });

</script>