<?php
/**
 * Place where CONSTANTS, ACTIONS and FILTERS are defined
 * Implementations of all of those are placed into inc/hooks.php
 * Loads dependencies files
 */

/**
 * CONSTANTS
 */
defined( 'TVE_DASH_PATH' ) || define( 'TVE_DASH_PATH', $GLOBALS['tve_dash_loaded_from'] === 'plugins' ? rtrim( plugin_dir_path( __FILE__ ), "/\\" ) : rtrim( get_template_directory(), "/\\" ) . "/thrive-dashboard" );
defined( 'TVE_DASH_TRANSLATE_DOMAIN' ) || define( 'TVE_DASH_TRANSLATE_DOMAIN', 'thrive-dash' );

defined( 'TVE_DASH_VERSION' ) || define( 'TVE_DASH_VERSION', require dirname( __FILE__ ) . '/version.php' );

/**
 * REQUIRED FILES
 */
require_once TVE_DASH_PATH . '/inc/hooks.php';
require_once TVE_DASH_PATH . '/inc/functions.php';

if ( is_admin() ) {
	$features = tve_dash_get_features();
	if ( isset( $features['api_connections'] ) ) {
		require_once TVE_DASH_PATH . '/inc/auto-responder/admin.php';
	}
	if ( isset( $features['icon_manager'] ) ) {
		require_once( TVE_DASH_PATH . '/inc/icon-manager/classes/Tve_Dash_Thrive_Icon_Manager.php' );
	}
}

if ( ( defined( 'DOING_AJAX' ) && DOING_AJAX ) || apply_filters( 'tve_leads_include_auto_responder', false ) ) {
	require_once TVE_DASH_PATH . '/inc/auto-responder/misc.php';
}

/**
 * AUTO-LOADERS
 */
spl_autoload_register( 'tve_dash_autoloader' );

/**
 * ACTIONS
 */
add_action( 'init', 'tve_dash_init_action' );
add_action( 'init', 'tve_dash_load_text_domain' );

if ( is_admin() ) {
	add_action( 'admin_menu', 'tve_dash_admin_menu', 10 );
	add_action( 'admin_enqueue_scripts', 'tve_dash_admin_enqueue_scripts' );
	add_action( 'wp_ajax_tve_dash_backend_ajax', 'tve_dash_backend_ajax' );
}

/**
 * FILTERS
 */
